/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.elements;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.elements.DrawableBlank;
import mezz.jei.gui.elements.GuiIconButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.client.config.HoverChecker;

public abstract class GuiIconToggleButton {
    private final IDrawable offIcon;
    private final IDrawable onIcon;
    private final GuiIconButton button;
    private final HoverChecker hoverChecker;

    public GuiIconToggleButton(IDrawable offIcon, IDrawable onIcon) {
        this.offIcon = offIcon;
        this.onIcon = onIcon;
        this.button = new GuiIconButton(2, new DrawableBlank(0, 0), (mc, x, y) -> true);
        this.hoverChecker = new HoverChecker((GuiButton)this.button, 0);
    }

    public void updateBounds(Rectangle area) {
        this.button.field_146120_f = area.width;
        this.button.field_146121_g = area.height;
        this.button.field_146128_h = area.x;
        this.button.field_146129_i = area.y;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.button.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        IDrawable icon = this.isIconToggledOn() ? this.onIcon : this.offIcon;
        icon.draw(minecraft, this.button.field_146128_h + 2, this.button.field_146129_i + 2);
    }

    public final boolean isMouseOver(int mouseX, int mouseY) {
        return this.hoverChecker.checkHover(mouseX, mouseY);
    }

    public final boolean handleMouseClick(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return this.button.func_146116_c(minecraft, mouseX, mouseY) && this.onMouseClicked(mouseX, mouseY);
    }

    public final void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            this.getTooltips(tooltip);
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, 150);
        }
    }

    protected abstract void getTooltips(List<String> var1);

    protected abstract boolean isIconToggledOn();

    protected abstract boolean onMouseClicked(int var1, int var2);
}

