/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.tileentity;

import info.jbcs.minecraft.vending.EnderPayApiUtils;
import info.jbcs.minecraft.vending.inventory.ContainerVendingStorageAttachment;
import info.jbcs.minecraft.vending.inventory.InventoryVendingStorageAttachment;
import info.jbcs.minecraft.vending.items.wrapper.IItemHandlerAdvanced;
import info.jbcs.minecraft.vending.items.wrapper.StorageAttachmentInvWrapper;
import info.jbcs.minecraft.vending.tileentity.TileEntityChestLike;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityVendingStorageAttachment
extends TileEntityChestLike
implements ISidedInventory,
IInventoryChangedListener {
    private int transferCooldown;
    private int ticksWithNoInventoryChanges;
    private StorageAttachmentInvWrapper inventoryWrapper;

    public TileEntityVendingStorageAttachment() {
        this.inventory = new InventoryVendingStorageAttachment(this);
        this.inventory.func_110134_a(this);
        this.inventoryWrapper = new StorageAttachmentInvWrapper(this.inventory);
        this.transferCooldown = -1;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    @Nonnull
    public String func_174875_k() {
        return "Vending:vendingStorageAttachment";
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        return new ContainerVendingStorageAttachment(playerInventory, this, this.haveAccess(playerIn));
    }

    public boolean haveAccess(EntityPlayer entityplayer) {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (!(te instanceof TileEntityVendingMachine)) {
            return true;
        }
        TileEntityVendingMachine machine = (TileEntityVendingMachine)te;
        return entityplayer.getDisplayNameString().equals(machine.getOwnerName()) || entityplayer.func_184812_l_();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound nbttagcompound) {
        return super.func_189515_b(nbttagcompound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.ticksWithNoInventoryChanges < Integer.MAX_VALUE) {
            ++this.ticksWithNoInventoryChanges;
        }
        --this.transferCooldown;
        if (this.transferCooldown < 0) {
            this.transferCooldown = 0;
        }
        if (this.transferCooldown == 0) {
            TileEntityVendingMachine machine = this.getMachine();
            if (machine == null) {
                return;
            }
            if (machine.vend(this.inventoryWrapper.getInputWrapper(), this.inventoryWrapper.getOutputWrapper(), false)) {
                this.func_70296_d();
                this.transferCooldown = 8;
            } else if (this.ticksWithNoInventoryChanges > 20) {
                IItemHandlerAdvanced input = this.inventoryWrapper.getInputWrapper();
                IItemHandlerAdvanced output = this.inventoryWrapper.getOutputWrapper();
                if (output.hasEmptySlots()) {
                    ItemStack stack;
                    int i;
                    for (i = 0; i < input.getSlots(); ++i) {
                        stack = input.getStackInSlot(i);
                        if (stack.func_190926_b() || machine.getInventoryWrapper().Accepts(stack) || !EnderPayApiUtils.isBanknote(stack)) continue;
                        output.insertItem(stack, false);
                        input.setStackInSlot(i, ItemStack.field_190927_a);
                        return;
                    }
                    for (i = 0; i < input.getSlots(); ++i) {
                        stack = input.getStackInSlot(i);
                        if (stack.func_190926_b() || machine.getInventoryWrapper().Accepts(stack)) continue;
                        output.insertItem(stack, false);
                        input.setStackInSlot(i, ItemStack.field_190927_a);
                        return;
                    }
                    for (i = 0; i < input.getSlots(); ++i) {
                        stack = input.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        output.insertItem(stack, false);
                        input.setStackInSlot(i, ItemStack.field_190927_a);
                        return;
                    }
                }
            }
        }
    }

    @Nullable
    private TileEntityVendingMachine getMachine() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        if (!(te instanceof TileEntityVendingMachine)) {
            return null;
        }
        return (TileEntityVendingMachine)te;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.inventoryWrapper.getOutputWrapper();
            }
            if (facing != EnumFacing.UP) {
                return (T)this.inventoryWrapper.getInputWrapper();
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP || super.hasCapability(capability, facing);
    }

    public void func_76316_a(@Nonnull IInventory inventory) {
        this.ticksWithNoInventoryChanges = 0;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.inventory.func_180463_a(side);
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.inventory.func_180462_a(index, itemStackIn, direction);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return this.inventory.func_180461_b(index, stack, direction);
    }
}

