/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.settings;

import info.jbcs.minecraft.vending.forge.LoaderWrapper;
import info.jbcs.minecraft.vending.settings.ISettings;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Settings
implements ISettings {
    private Configuration config;
    private boolean use_custom_creative_tab;
    private boolean close_on_sold_out;
    private boolean close_on_partial_sold_out;
    private boolean block_placing_next_to_doors;
    private boolean transfer_to_inventory;
    private int offsetY;

    private void loadConfig(Configuration config) {
        this.use_custom_creative_tab = config.get("general", "use_custom_creative_tab", true, "Add a new tab to creative mode and put all vending blocks there.").getBoolean(true);
        this.close_on_sold_out = config.get("general", "close_on_sold_out", false, "Stop accepting item after last item is sold out.").getBoolean(false);
        this.close_on_partial_sold_out = config.get("general", "close_on_partial_sold_out", false, "Stop accepting item after some item were sold out.").getBoolean(false);
        this.block_placing_next_to_doors = config.get("general", "block_placing_next_to_doors", false, "Check for nearby doors when block is placed (Use specialized mod if you want more advanced restrictions)").getBoolean(false);
        this.transfer_to_inventory = config.get("general", "transfer_to_inventory", false, "Transfer sold item directly to player's inventory.").getBoolean(false);
        int defaultOffset = LoaderWrapper.isWAILALoaded() ? 40 : 15;
        this.offsetY = config.get("general", "offsetY", defaultOffset, "Set Y offset of HUD").getInt(defaultOffset);
    }

    @Override
    public void loadConfig(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.loadConfig(this.config);
    }

    @Override
    public void save() {
        this.config.save();
    }

    @Override
    public boolean shouldUseCustomCreativeTab() {
        return this.use_custom_creative_tab;
    }

    @Override
    public boolean shouldCloseOnSoldOut() {
        return this.close_on_sold_out;
    }

    @Override
    public boolean shouldCloseOnPartialSoldOut() {
        return this.close_on_partial_sold_out;
    }

    @Override
    public boolean isPlacingNextToDoorsBlocked() {
        return this.block_placing_next_to_doors;
    }

    @Override
    public boolean shouldTransferToInventory() {
        return this.transfer_to_inventory;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }
}

