/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.network.server;

import info.jbcs.minecraft.vending.init.VendingBlocks;
import info.jbcs.minecraft.vending.init.VendingItems;
import info.jbcs.minecraft.vending.network.AbstractMessage;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class MessageWrenchToInventory
extends AbstractMessage.AbstractServerMessage<MessageWrenchToInventory> {
    private int x;
    private int y;
    private int z;
    private boolean infinite;
    private String ownerName;

    public MessageWrenchToInventory() {
    }

    public MessageWrenchToInventory(TileEntity tileEntityVendingMachine, boolean infinite, String ownerName) {
        TileEntityVendingMachine entity = (TileEntityVendingMachine)tileEntityVendingMachine;
        BlockPos blockPos = entity.func_174877_v();
        this.x = blockPos.func_177958_n();
        this.y = blockPos.func_177956_o();
        this.z = blockPos.func_177952_p();
        this.infinite = infinite;
        this.ownerName = ownerName;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.infinite = buffer.readBoolean();
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.infinite);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.field_71071_by.func_70448_g().func_190926_b() || player.field_71071_by.func_70448_g().func_77973_b() != VendingItems.ITEM_WRENCH) {
            return;
        }
        TileEntity tileEntity = player.field_70170_p.func_175625_s(new BlockPos(this.x, this.y, this.z));
        if (!(tileEntity instanceof TileEntityVendingMachine)) {
            return;
        }
        TileEntityVendingMachine entity = (TileEntityVendingMachine)tileEntity;
        ItemStack itemStack = entity.isMultiple() ? new ItemStack((Block)VendingBlocks.BLOCK_VENDING_MACHINE_MULTIPLE, 1, tileEntity.func_145832_p()) : (entity.isAdvanced() ? new ItemStack((Block)VendingBlocks.BLOCK_VENDING_MACHINE_ADVANCED, 1, tileEntity.func_145832_p()) : new ItemStack((Block)VendingBlocks.BLOCK_VENDING_MACHINE, 1, tileEntity.func_145832_p()));
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("ownerName", this.ownerName);
        tagCompound.func_74757_a("infinite", this.infinite);
        tagCompound.func_74757_a("preConfigured", true);
        itemStack.func_77982_d(tagCompound);
        player.field_71071_by.func_70441_a(itemStack);
    }
}

