/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.elements;

import com.kamildanak.minecraft.foamflower.gui.input.IPickBlockHandler;
import com.kamildanak.minecraft.foamflower.inventory.ContainerPickBlock;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiPickBlock
extends InventoryEffectRenderer {
    private static final ResourceLocation CREATIVE_INVENTORY_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static int selectedTabIndex = CreativeTabs.field_78030_b.func_78021_a();
    private static int tabPage = 0;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private GuiTextField searchField;
    private boolean clearSearch;
    private int maxPages = 0;
    private GuiScreen parent;
    private ContainerPickBlock containterPickBlock = (ContainerPickBlock)this.field_147002_h;

    public GuiPickBlock(EntityPlayer player, ItemStack stack, GuiScreen parent) {
        super((Container)new ContainerPickBlock());
        this.field_146291_p = true;
        this.field_147000_g = 136;
        this.field_146999_f = 195;
        this.containterPickBlock.resultSlot.func_75215_d(stack);
        this.parent = parent;
    }

    protected void func_184098_a(@Nullable Slot slotIn, int slotId, int mouseButton, ClickType type) {
        this.clearSearch = true;
        if (this.field_147002_h != null) {
            ItemStack itemStack4;
            ItemStack itemStack3 = slotIn == null ? ItemStack.field_190927_a : this.field_147002_h.func_75139_a(slotIn.field_75222_d).func_75211_c();
            if (itemStack3.func_77969_a(itemStack4 = this.containterPickBlock.resultSlot.func_75211_c().func_77946_l()) && itemStack4.func_190916_E() < itemStack4.func_77976_d()) {
                itemStack4.func_190920_e(itemStack4.func_190916_E() + 1);
            } else {
                itemStack4 = itemStack3;
            }
            this.containterPickBlock.resultSlot.func_75215_d(itemStack4);
        }
    }

    protected void func_175378_g() {
        int i = this.field_147003_i;
        super.func_175378_g();
        if (this.searchField != null && this.field_147003_i != i) {
            this.searchField.field_146209_f = this.field_147003_i + 82;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 82, this.field_147009_r + 6, 89, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(15);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(false);
        this.searchField.func_146193_g(0xFFFFFF);
        int i = selectedTabIndex;
        selectedTabIndex = -1;
        this.setCurrentCreativeTab(CreativeTabs.field_78032_a[i]);
        int tabCount = CreativeTabs.field_78032_a.length;
        if (tabCount > 12) {
            this.field_146292_n.add(new GuiButton(101, this.field_147003_i, this.field_147009_r - 50, 20, 20, "<"));
            this.field_146292_n.add(new GuiButton(102, this.field_147003_i + this.field_146999_f - 20, this.field_147009_r - 50, 20, 20, ">"));
            this.maxPages = (tabCount - 12) / 10 + 1;
        }
        this.field_146292_n.add(new GuiButton(100, this.field_147003_i + 34, this.field_147009_r + 109, 70, 20, I18n.func_135052_a((String)"gui.foamflower.select", (Object[])new Object[0]).trim()));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!CreativeTabs.field_78032_a[selectedTabIndex].hasSearchBar()) {
            if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74310_D)) {
                this.setCurrentCreativeTab(CreativeTabs.field_78027_g);
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        } else {
            if (this.clearSearch) {
                this.clearSearch = false;
                this.searchField.func_146180_a("");
            }
            if (!this.func_146983_a(keyCode)) {
                if (this.searchField.func_146201_a(typedChar, keyCode)) {
                    this.updateCreativeSearch();
                } else {
                    super.func_73869_a(typedChar, keyCode);
                }
            }
        }
    }

    private void updateCreativeSearch() {
        ContainerPickBlock guicontainercreative$containercreative = (ContainerPickBlock)this.field_147002_h;
        guicontainercreative$containercreative.itemList.clear();
        CreativeTabs tab = CreativeTabs.field_78032_a[selectedTabIndex];
        if (tab.hasSearchBar() && tab != CreativeTabs.field_78027_g) {
            tab.func_78018_a(guicontainercreative$containercreative.itemList);
            this.updateFilteredItems(guicontainercreative$containercreative);
            return;
        }
        for (Item item : Item.field_150901_e) {
            if (item == null || item.func_77640_w() == null) continue;
            item.func_150895_a(item.func_77640_w(), guicontainercreative$containercreative.itemList);
        }
        this.updateFilteredItems(guicontainercreative$containercreative);
    }

    private void updateFilteredItems(ContainerPickBlock guicontainercreative$containercreative) {
        Iterator iterator = guicontainercreative$containercreative.itemList.iterator();
        String s1 = this.searchField.func_146179_b().toLowerCase(Locale.ROOT);
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            boolean flag = false;
            for (String s : itemstack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, () -> this.field_146297_k.field_71474_y.field_82882_x)) {
                if (!TextFormatting.func_110646_a((String)s).toLowerCase(Locale.ROOT).contains(s1)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            iterator.remove();
        }
        this.currentScroll = 0.0f;
        guicontainercreative$containercreative.scrollTo(0.0f);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        CreativeTabs creativetabs = CreativeTabs.field_78032_a[selectedTabIndex];
        if (creativetabs != null && creativetabs.func_78019_g()) {
            GlStateManager.func_179084_k();
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)creativetabs.func_78024_c(), (Object[])new Object[0]), 8, 6, 0x404040);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            int i = mouseX - this.field_147003_i;
            int j = mouseY - this.field_147009_r;
            for (CreativeTabs creativetabs : CreativeTabs.field_78032_a) {
                if (!this.isMouseOverTab(creativetabs, i, j)) continue;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (state == 0) {
            int i = mouseX - this.field_147003_i;
            int j = mouseY - this.field_147009_r;
            for (CreativeTabs creativetabs : CreativeTabs.field_78032_a) {
                if (creativetabs == null || !this.isMouseOverTab(creativetabs, i, j) || creativetabs == CreativeTabs.field_78036_m || creativetabs == CreativeTabs.field_192395_m) continue;
                this.setCurrentCreativeTab(creativetabs);
                return;
            }
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    private boolean needsScrollBars() {
        if (CreativeTabs.field_78032_a[selectedTabIndex] == null) {
            return false;
        }
        return selectedTabIndex != CreativeTabs.field_78036_m.func_78021_a() && selectedTabIndex != CreativeTabs.field_192395_m.func_78021_a() && CreativeTabs.field_78032_a[selectedTabIndex].func_78017_i() && ((ContainerPickBlock)this.field_147002_h).canScroll();
    }

    private void setCurrentCreativeTab(CreativeTabs tab) {
        if (tab == null) {
            return;
        }
        int i = selectedTabIndex;
        selectedTabIndex = tab.func_78021_a();
        ContainerPickBlock guicontainercreative$containercreative = (ContainerPickBlock)this.field_147002_h;
        this.field_147008_s.clear();
        guicontainercreative$containercreative.itemList.clear();
        tab.func_78018_a(guicontainercreative$containercreative.itemList);
        if (this.searchField != null) {
            if (tab.hasSearchBar()) {
                this.searchField.func_146189_e(true);
                this.searchField.func_146205_d(false);
                this.searchField.func_146195_b(true);
                this.searchField.func_146180_a("");
                this.searchField.field_146218_h = tab.getSearchbarWidth();
                this.searchField.field_146209_f = this.field_147003_i + 171 - this.searchField.field_146218_h;
                this.updateCreativeSearch();
            } else {
                this.searchField.func_146189_e(false);
                this.searchField.func_146205_d(true);
                this.searchField.func_146195_b(false);
            }
        }
        this.currentScroll = 0.0f;
        guicontainercreative$containercreative.scrollTo(0.0f);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = (((ContainerPickBlock)this.field_147002_h).itemList.size() + 9 - 1) / 9 - 5;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerPickBlock)this.field_147002_h).scrollTo(this.currentScroll);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean flag = Mouse.isButtonDown((int)0);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerPickBlock)this.field_147002_h).scrollTo(this.currentScroll);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int start = tabPage * 10;
        int end = Math.min(CreativeTabs.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        boolean rendered = false;
        for (CreativeTabs creativetabs : Arrays.copyOfRange(CreativeTabs.field_78032_a, start, end)) {
            if (creativetabs == null || creativetabs == CreativeTabs.field_78036_m || creativetabs == CreativeTabs.field_192395_m || !this.renderCreativeInventoryHoveringText(creativetabs, mouseX, mouseY)) continue;
            rendered = true;
            break;
        }
        if (this.maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, this.maxPages + 1);
            int width = this.field_146289_q.func_78256_a(page);
            GlStateManager.func_179140_f();
            this.field_73735_i = 300.0f;
            this.field_146296_j.field_77023_b = 300.0f;
            this.field_146289_q.func_78276_b(page, this.field_147003_i + this.field_146999_f / 2 - width / 2, this.field_147009_r - 44, -1);
            this.field_73735_i = 0.0f;
            this.field_146296_j.field_77023_b = 0.0f;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (selectedTabIndex == CreativeTabs.field_78027_g.func_78021_a()) {
            Map map;
            List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, () -> this.field_146297_k.field_71474_y.field_82882_x);
            CreativeTabs creativetabs = stack.func_77973_b().func_77640_w();
            if (creativetabs == null && stack.func_77973_b() == Items.field_151134_bR && (map = EnchantmentHelper.func_82781_a((ItemStack)stack)).size() == 1) {
                Enchantment enchantment = (Enchantment)map.keySet().iterator().next();
                for (CreativeTabs creativetabs1 : CreativeTabs.field_78032_a) {
                    if (!creativetabs1.func_111226_a(enchantment.field_77351_y)) continue;
                    creativetabs = creativetabs1;
                    break;
                }
            }
            if (creativetabs != null) {
                list.add(1, "" + TextFormatting.BOLD + TextFormatting.BLUE + I18n.func_135052_a((String)creativetabs.func_78024_c(), (Object[])new Object[0]));
            }
            for (int i = 0; i < list.size(); ++i) {
                if (i == 0) {
                    list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                    continue;
                }
                list.set(i, TextFormatting.GRAY + (String)list.get(i));
            }
            GuiUtils.preItemToolTip((ItemStack)stack);
            this.func_146283_a(list, x, y);
            GuiUtils.postItemToolTip();
        } else {
            super.func_146285_a(stack, x, y);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        CreativeTabs creativetabs = CreativeTabs.field_78032_a[selectedTabIndex];
        int start = tabPage * 10;
        int end = Math.min(CreativeTabs.field_78032_a.length, (tabPage + 1) * 10 + 2);
        if (tabPage != 0) {
            start += 2;
        }
        for (CreativeTabs creativetabs1 : Arrays.copyOfRange(CreativeTabs.field_78032_a, start, end)) {
            this.field_146297_k.func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
            if (creativetabs1 == null || creativetabs1 == CreativeTabs.field_78036_m || creativetabs1 == CreativeTabs.field_192395_m || creativetabs1.func_78021_a() == selectedTabIndex) continue;
            this.drawTab(creativetabs1);
        }
        if (tabPage != 0 && creativetabs != CreativeTabs.field_78027_g) {
            this.field_146297_k.func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
            this.drawTab(CreativeTabs.field_78027_g);
        }
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("foamflower:textures/gui/pickblock/tab_" + creativetabs.func_78015_f()));
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchField.func_146194_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_147003_i + 175;
        int j = this.field_147009_r + 18;
        int k = j + 112;
        this.field_146297_k.func_110434_K().func_110577_a(CREATIVE_INVENTORY_TABS);
        if (creativetabs.func_78017_i()) {
            this.func_73729_b(i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        }
        if ((creativetabs == null || creativetabs.getTabPage() != tabPage) && creativetabs != CreativeTabs.field_78027_g && creativetabs != CreativeTabs.field_78036_m && creativetabs != CreativeTabs.field_192395_m) {
            return;
        }
        this.drawTab(creativetabs);
    }

    protected boolean isMouseOverTab(CreativeTabs tab, int mouseX, int mouseY) {
        if (tab.getTabPage() != tabPage && tab != CreativeTabs.field_78027_g && tab != CreativeTabs.field_78036_m && tab != CreativeTabs.field_192395_m) {
            return false;
        }
        int i = tab.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (i == 5) {
            j = this.field_146999_f - 28 + 2;
        } else if (i > 0) {
            j += i;
        }
        k = tab.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        return mouseX >= j && mouseX <= j + 28 && mouseY >= k && mouseY <= k + 32;
    }

    protected boolean renderCreativeInventoryHoveringText(CreativeTabs tab, int mouseX, int mouseY) {
        int i = tab.func_78020_k();
        int j = 28 * i;
        int k = 0;
        if (i == 5) {
            j = this.field_146999_f - 28 + 2;
        } else if (i > 0) {
            j += i;
        }
        k = tab.func_78023_l() ? (k -= 32) : (k += this.field_147000_g);
        if (this.func_146978_c(j + 3, k + 3, 23, 27, mouseX, mouseY)) {
            if (tab == CreativeTabs.field_78036_m) {
                return false;
            }
            if (tab == CreativeTabs.field_192395_m) {
                return false;
            }
            this.func_146279_a(I18n.func_135052_a((String)tab.func_78024_c(), (Object[])new Object[0]), mouseX, mouseY);
            return true;
        }
        return false;
    }

    protected void drawTab(CreativeTabs tab) {
        if (tab == CreativeTabs.field_78036_m) {
            return;
        }
        if (tab == CreativeTabs.field_192395_m) {
            return;
        }
        boolean flag = tab.func_78021_a() == selectedTabIndex;
        boolean flag1 = tab.func_78023_l();
        int i = tab.func_78020_k();
        int j = i * 28;
        int k = 0;
        int l = this.field_147003_i + 28 * i;
        int i1 = this.field_147009_r;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (i == 5) {
            l = this.field_147003_i + this.field_146999_f - 28;
        } else if (i > 0) {
            l += i;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.field_147000_g - 4;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.func_73729_b(l, i1, j, k, 28, 32);
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        i1 = i1 + 8 + (flag1 ? 1 : -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        ItemStack itemstack = tab.func_151244_d();
        this.field_146296_j.func_180450_b(itemstack, l += 6, i1);
        this.field_146296_j.func_175030_a(this.field_146289_q, itemstack, l, i1);
        GlStateManager.func_179140_f();
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 100: {
                ItemStack stack = this.containterPickBlock.resultSlot.func_75211_c();
                if (this.parent instanceof IPickBlockHandler) {
                    ((IPickBlockHandler)this.parent).blockPicked(stack);
                }
                Minecraft.func_71410_x().func_147108_a(this.parent);
                break;
            }
            case 101: {
                tabPage = Math.max(tabPage - 1, 0);
                break;
            }
            case 102: {
                tabPage = Math.min(tabPage + 1, this.maxPages);
            }
        }
    }
}

