/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.tileentity;

import info.jbcs.minecraft.vending.Utils;
import info.jbcs.minecraft.vending.init.VendingSoundEvents;
import info.jbcs.minecraft.vending.inventory.ContainerAdvancedVendingMachine;
import info.jbcs.minecraft.vending.inventory.ContainerMultipleVendingMachine;
import info.jbcs.minecraft.vending.inventory.ContainerVendingMachine;
import info.jbcs.minecraft.vending.inventory.InventoryVendingMachine;
import info.jbcs.minecraft.vending.inventory.InventoryVendingStorageAttachment;
import info.jbcs.minecraft.vending.items.wrapper.IItemHandlerAdvanced;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingHelper;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingMachineInvWrapper;
import info.jbcs.minecraft.vending.stats.ModStats;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingStorageAttachment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityVendingMachine
extends TileEntityLockable
implements IInventoryChangedListener {
    private InventoryVendingMachine inventory = new InventoryVendingMachine(this);
    private VendingMachineInvWrapper itemHandler = new VendingMachineInvWrapper(this, this.inventory);
    private boolean advanced = false;
    private boolean infinite = false;
    private boolean multiple = false;
    private boolean open = true;
    private String ownerName = "";

    public TileEntityVendingMachine() {
    }

    public TileEntityVendingMachine(boolean advanced, boolean infinite, boolean multiple) {
        this();
        this.advanced = advanced;
        this.infinite = infinite;
        this.multiple = multiple;
    }

    @Nullable
    public InventoryVendingStorageAttachment getAttachmentInventory() {
        TileEntity tileEntity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        if (!(tileEntity instanceof TileEntityVendingStorageAttachment)) {
            return null;
        }
        return ((TileEntityVendingStorageAttachment)tileEntity).inventory;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        if (this.advanced && i == 10 || this.advanced && this.multiple && i == 13) {
            return;
        }
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return index < 9;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    @Nonnull
    public Container func_174876_a(@Nonnull InventoryPlayer playerInventory, @Nonnull EntityPlayer playerIn) {
        if (this.isAdvanced()) {
            return new ContainerAdvancedVendingMachine((IInventory)playerInventory, this);
        }
        if (this.isMultiple()) {
            return new ContainerMultipleVendingMachine((IInventory)playerInventory, this);
        }
        return new ContainerVendingMachine((IInventory)playerInventory, this);
    }

    @Nonnull
    public String func_174875_k() {
        return "vending:vendingMachine";
    }

    @Nonnull
    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public void setInfinite(boolean infinite) {
        this.infinite = infinite;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.inventory.readFromNBT(nbttagcompound);
        this.ownerName = nbttagcompound.func_74779_i("owner");
        this.advanced = nbttagcompound.func_74767_n("advanced");
        this.infinite = nbttagcompound.func_74767_n("infinite");
        this.multiple = nbttagcompound.func_74767_n("multiple");
        this.open = !nbttagcompound.func_74764_b("open") || nbttagcompound.func_74767_n("open");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = this.inventory.writeToNBT(nbttagcompound);
        nbttagcompound.func_74778_a("owner", this.ownerName);
        nbttagcompound.func_74757_a("advanced", this.advanced);
        nbttagcompound.func_74757_a("infinite", this.infinite);
        nbttagcompound.func_74757_a("multiple", this.multiple);
        nbttagcompound.func_74757_a("open", this.open);
        return super.func_189515_b(nbttagcompound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_189515_b(var1);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, var1);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void vend(EntityPlayer entityPlayer, boolean simulate) {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean vended = VendingHelper.vend(this, entityPlayer, simulate);
        if (vended) {
            entityPlayer.func_71029_a(ModStats.VENDING_MACHINES_USED);
        }
        SoundEvent sound = vended ? VendingSoundEvents.PROCESSED : VendingSoundEvents.FORBIDDEN;
        this.func_145831_w().func_184133_a(null, this.func_174877_v(), sound, SoundCategory.MASTER, 0.3f, 0.6f);
    }

    public boolean vend(IItemHandlerAdvanced input, IItemHandlerAdvanced output, boolean simulate) {
        return VendingHelper.vend(this, input, output, simulate);
    }

    public void func_76316_a(@Nonnull IInventory inventory) {
        Utils.markBlockForUpdate(this.func_145831_w(), this.func_174877_v());
    }

    public VendingMachineInvWrapper getInventoryWrapper() {
        return this.itemHandler;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)EmptyHandler.INSTANCE;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

