/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.proxy;

import info.jbcs.minecraft.vending.block.BlockVendingMachine;
import info.jbcs.minecraft.vending.block.BlockVendingStorageAttachment;
import info.jbcs.minecraft.vending.block.EnumSupports;
import info.jbcs.minecraft.vending.gui.hud.HintHUD;
import info.jbcs.minecraft.vending.init.VendingBlocks;
import info.jbcs.minecraft.vending.init.VendingItems;
import info.jbcs.minecraft.vending.proxy.CommonProxy;
import info.jbcs.minecraft.vending.renderer.TileEntityVendingMachineRenderer;
import info.jbcs.minecraft.vending.renderer.TileEntityVendingStorageAttachmentRenderer;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingStorageAttachment;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    private Minecraft mc;

    @Override
    public void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new HintHUD(Minecraft.func_71410_x()));
    }

    @Override
    public void registerRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVendingMachine.class, (TileEntitySpecialRenderer)new TileEntityVendingMachineRenderer());
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        renderItem.func_175037_a().func_178086_a(VendingItems.ITEM_WRENCH, 0, new ModelResourceLocation("vending:vendingMachineWrench", "inventory"));
        for (int i = 0; i < EnumSupports.length; ++i) {
            this.registerVendingMachineRenderer(renderItem, VendingBlocks.BLOCK_VENDING_MACHINE, i);
            this.registerVendingMachineRenderer(renderItem, VendingBlocks.BLOCK_VENDING_MACHINE_ADVANCED, i);
            this.registerVendingMachineRenderer(renderItem, VendingBlocks.BLOCK_VENDING_MACHINE_MULTIPLE, i);
        }
        this.registerTESRRender((Block)VendingBlocks.BLOCK_VENDING_STORAGE_ATTACHMENT, new TileEntityVendingStorageAttachmentRenderer(), TileEntityVendingStorageAttachment.class);
    }

    private void registerVendingMachineRenderer(RenderItem renderItem, BlockVendingMachine block, int i) {
        renderItem.func_175037_a().func_178086_a(Item.func_150898_a((Block)block), i, new ModelResourceLocation("vending:" + block.getName(), "support=" + EnumSupports.byMetadata(i).getUnlocalizedName()));
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? this.mc.field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public IThreadListener getThreadFromContext(MessageContext ctx) {
        return ctx.side.isClient() ? this.mc : super.getThreadFromContext(ctx);
    }

    private void registerTESRRender(Block block, TileEntitySpecialRenderer renderer, Class<? extends TileEntity> te) {
        ClientRegistry.bindTileEntitySpecialRenderer(te, (TileEntitySpecialRenderer)renderer);
        Item item = Item.func_150898_a((Block)block);
        ForgeHooksClient.registerTESRItemStack((Item)item, (int)0, te);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockVendingStorageAttachment.FACING}).func_178441_a());
    }
}

