/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending.items.wrapper.transactions;

import info.jbcs.minecraft.vending.EnderPayApiUtils;
import info.jbcs.minecraft.vending.Utils;
import info.jbcs.minecraft.vending.Vending;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedInventoryWrapper;
import info.jbcs.minecraft.vending.items.wrapper.AdvancedItemHandlerHelper;
import info.jbcs.minecraft.vending.items.wrapper.IItemHandlerAdvanced;
import info.jbcs.minecraft.vending.items.wrapper.transactions.BuyRequest;
import info.jbcs.minecraft.vending.items.wrapper.transactions.BuyResponse;
import info.jbcs.minecraft.vending.items.wrapper.transactions.VendingMachineInvWrapper;
import info.jbcs.minecraft.vending.tileentity.TileEntityVendingMachine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class VendingHelper {
    public static boolean vend(TileEntityVendingMachine machine, IItemHandlerAdvanced input, IItemHandlerAdvanced output, boolean simulate) {
        VendingMachineInvWrapper machineInvWrapper = machine.getInventoryWrapper();
        long availableCredits = input.getCreditsSum(true);
        if (AdvancedItemHandlerHelper.countNotNull(output.insertItems(machineInvWrapper.getSoldItems(), true)) != 0) {
            return false;
        }
        if (input.storeCredits(machineInvWrapper.getCreditsToReturn(), true) != 0L) {
            return false;
        }
        for (int i = 0; i < input.getSlots(); ++i) {
            BuyResponse response = machineInvWrapper.Accept(new BuyRequest(availableCredits, input.getStackInSlot(i).func_77946_l(), simulate));
            if (!response.isTransactionCompleted()) continue;
            input.setStackInSlot(i, response.getChange());
            input.storeCredits(response.getCreditsToReturn(), false);
            output.insertItems(response.getReturnedStacks(), false);
            return true;
        }
        return false;
    }

    public static boolean vend(TileEntityVendingMachine machine, EntityPlayer entityPlayer, boolean simulate) {
        VendingMachineInvWrapper machineInvWrapper = machine.getInventoryWrapper();
        ItemStack offeredItem = entityPlayer.field_71071_by.func_70448_g();
        long availableCredits = EnderPayApiUtils.getAvailableCredits(entityPlayer);
        AdvancedInventoryWrapper playerInventory = new AdvancedInventoryWrapper((IItemHandlerModifiable)new PlayerMainInvWrapper(entityPlayer.field_71071_by));
        if (Vending.settings.shouldTransferToInventory() && AdvancedItemHandlerHelper.countNotNull(playerInventory.insertItems(machineInvWrapper.getSoldItems(), true)) != 0) {
            return false;
        }
        BuyRequest buyRequest = new BuyRequest(availableCredits, offeredItem, simulate);
        BuyResponse response = machineInvWrapper.Accept(buyRequest);
        if (response.isTransactionCompleted()) {
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, response.getChange());
            if (Vending.settings.shouldTransferToInventory()) {
                playerInventory.insertItems(response.getReturnedStacks(), false);
            } else {
                VendingHelper.dispenseItems(machine, response.getReturnedStacks(), entityPlayer);
            }
            EnderPayApiUtils.addToBalance(entityPlayer, response.getCreditsToReturn());
            return true;
        }
        return false;
    }

    private static void dispenseItems(TileEntityVendingMachine machine, NonNullList<ItemStack> stacks, EntityPlayer entityPlayer) {
        for (ItemStack vended : stacks) {
            Utils.throwItemAtPlayer(entityPlayer, machine.func_145831_w(), machine.func_174877_v(), vended);
        }
    }
}

