/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.vending;

import com.kamildanak.minecraft.enderpay.api.EnderPayApi;
import com.kamildanak.minecraft.enderpay.api.NoSuchAccountException;
import com.kamildanak.minecraft.enderpay.api.NotABanknoteException;
import info.jbcs.minecraft.vending.forge.LoaderWrapper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Optional;

public class EnderPayApiUtils {
    public static ItemStack getBanknote(long value) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.getBanknoteOptional(value);
        }
        return ItemStack.field_190927_a;
    }

    @Optional.Method(modid="enderpay")
    private static ItemStack getBanknoteOptional(long value) {
        return EnderPayApi.getBanknote((long)value);
    }

    public static void addToBalance(EntityPlayer entityPlayer, long creditsToReturn) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            EnderPayApiUtils.addToBalanceOptional(entityPlayer, creditsToReturn);
        }
    }

    @Optional.Method(modid="enderpay")
    private static void addToBalanceOptional(EntityPlayer entityPlayer, long creditsToReturn) {
        try {
            EnderPayApi.addToBalance((UUID)entityPlayer.func_110124_au(), (long)creditsToReturn);
        }
        catch (NoSuchAccountException noSuchAccountException) {
            // empty catch block
        }
    }

    public static String getCurrencyName(long amount) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.getCurrencyNameOptional(amount);
        }
        return "";
    }

    @Optional.Method(modid="enderpay")
    private static String getCurrencyNameOptional(long amount) {
        return EnderPayApi.getCurrencyName((long)amount);
    }

    public static boolean isFilledBanknote(ItemStack stack) {
        return LoaderWrapper.isEnderPayLoaded() && EnderPayApiUtils.isFilledBanknoteOptional(stack);
    }

    @Optional.Method(modid="enderpay")
    private static boolean isFilledBanknoteOptional(ItemStack stack) {
        return EnderPayApi.isValidFilledBanknote((ItemStack)stack);
    }

    @Optional.Method(modid="enderpay")
    private static boolean isBanknoteOptional(ItemStack itemStack) {
        return EnderPayApi.isBlankBanknote((ItemStack)itemStack) || EnderPayApi.isFilledBanknote((ItemStack)itemStack);
    }

    public static NonNullList<ItemStack> filterBanknotes(NonNullList<ItemStack> soldItems) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return soldItems;
        }
        for (int i = 0; i < soldItems.size(); ++i) {
            if (!EnderPayApiUtils.isBanknoteOptional((ItemStack)soldItems.get(i))) continue;
            soldItems.set(i, (Object)ItemStack.field_190927_a);
        }
        return soldItems;
    }

    public static NonNullList<ItemStack> filterBlankBanknotes(NonNullList<ItemStack> soldItems) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return soldItems;
        }
        for (int i = 0; i < soldItems.size(); ++i) {
            if (!EnderPayApiUtils.isBanknoteOptional((ItemStack)soldItems.get(i)) || EnderPayApiUtils.isFilledBanknoteOptional((ItemStack)soldItems.get(i))) continue;
            soldItems.set(i, (Object)ItemStack.field_190927_a);
        }
        return soldItems;
    }

    public static long originalValueCreditsSum(NonNullList<ItemStack> stacks) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.originalValueCreditsSumOptional(stacks);
        }
        return 0L;
    }

    @Optional.Method(modid="enderpay")
    private static long originalValueCreditsSumOptional(NonNullList<ItemStack> stacks) {
        long sum = 0L;
        for (ItemStack itemStack : stacks) {
            if (itemStack.func_190926_b() || !EnderPayApi.isValidFilledBanknote((ItemStack)itemStack)) continue;
            try {
                sum += EnderPayApi.getBanknoteOriginalValue((ItemStack)itemStack);
            }
            catch (NotABanknoteException notABanknoteException) {}
        }
        return sum;
    }

    public static long currentValueCreditsSum(NonNullList<ItemStack> stacks) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.currentValueCreditsSumOptional(stacks);
        }
        return 0L;
    }

    @Optional.Method(modid="enderpay")
    private static long currentValueCreditsSumOptional(NonNullList<ItemStack> stacks) {
        long sum = 0L;
        for (ItemStack itemStack : stacks) {
            if (itemStack.func_190926_b() || !EnderPayApi.isValidFilledBanknote((ItemStack)itemStack)) continue;
            try {
                sum += EnderPayApi.getBanknoteCurrentValue((ItemStack)itemStack);
            }
            catch (NotABanknoteException notABanknoteException) {}
        }
        return sum;
    }

    public static NonNullList<ItemStack> filterFilledBanknotes(NonNullList<ItemStack> itemStacks) {
        if (!LoaderWrapper.isEnderPayLoaded()) {
            return itemStacks;
        }
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (!EnderPayApiUtils.isFilledBanknoteOptional((ItemStack)itemStacks.get(i))) continue;
            itemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        return itemStacks;
    }

    public static long getAvailableCredits(EntityPlayer entityPlayer) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.getAvailableCreditsOptional(entityPlayer);
        }
        return 0L;
    }

    @Optional.Method(modid="enderpay")
    private static long getAvailableCreditsOptional(EntityPlayer entityPlayer) {
        try {
            return EnderPayApi.getBalance((UUID)entityPlayer.func_110124_au());
        }
        catch (NoSuchAccountException noSuchAccountException) {
            return 0L;
        }
    }

    public static long getBanknoteOriginalValue(ItemStack stack) {
        if (LoaderWrapper.isEnderPayLoaded()) {
            return EnderPayApiUtils.getBanknoteOriginalValueOptional(stack);
        }
        return 0L;
    }

    @Optional.Method(modid="enderpay")
    private static long getBanknoteOriginalValueOptional(ItemStack stack) {
        try {
            return EnderPayApi.getBanknoteOriginalValue((ItemStack)stack);
        }
        catch (NotABanknoteException notABanknoteException) {
            return 0L;
        }
    }

    public static boolean isBanknote(ItemStack itemStack) {
        return LoaderWrapper.isEnderPayLoaded() && EnderPayApiUtils.isBanknoteOptional(itemStack);
    }
}

