/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.layouts;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.layouts.AbstractLayout;
import org.lwjgl.opengl.GL11;

public class CenteredLayout
extends AbstractLayout {
    private boolean horizontal;
    private boolean vertical;
    private int cX;
    private int cY;

    public CenteredLayout(int x, int y, int w, int h, boolean horizontal, boolean vertical) {
        super(x, y, w, h);
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.cX = (x + w) / 2;
        this.cY = (y + h) / 2;
    }

    @Override
    public int getHeight() {
        if (this.hidden) {
            return 0;
        }
        return this.h;
    }

    @Override
    public int getWidth() {
        if (this.hidden) {
            return 0;
        }
        return this.w;
    }

    @Override
    public void render() {
        this.cX = this.w / 2;
        this.cY = this.h / 2;
        if (this.getChildren() == null || this.hidden) {
            return;
        }
        for (GuiElement e : this.getChildren()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            e.x = this.horizontal ? this.cX - e.getWidth() / 2 : this.x;
            e.y = this.vertical ? this.cY - e.getHeight() / 2 : this.y;
            e.render();
        }
    }
}

