/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.elements;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.elements.GuiRenderItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import org.lwjgl.opengl.GL11;

public class GuiItemsList
extends GuiElement {
    private NonNullList<ItemStack> items;

    public GuiItemsList(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    @Override
    public void render() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glDisable((int)2896);
        this.drawItemsWithLabel(this.gui.fontRenderer(), this.x, this.y, this.items);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int getHeight() {
        if (this.hidden || this.items == null) {
            return 0;
        }
        return 14;
    }

    @Override
    public int getWidth() {
        if (this.hidden || this.items == null) {
            return 0;
        }
        int c = 0;
        for (ItemStack itemStack : this.items) {
            if (itemStack.func_190926_b()) continue;
            ++c;
        }
        return 18 * c;
    }

    private void drawNumberForItem(FontRenderer fontRenderer, ItemStack stack, int ux, int uy) {
        if (stack.func_190926_b() || stack.func_190916_E() < 2) {
            return;
        }
        String line = "" + stack.func_190916_E();
        int x = ux + 19 - 2 - fontRenderer.func_78256_a(line);
        int y = uy + 6 + 3;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
        this.gui.drawString(line, x + 1, y + 1, 0x888888);
        this.gui.drawString(line, x, y, 0xFFFFFF);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-500.0f);
    }

    private void drawItemsWithLabel(FontRenderer fontRenderer, int x, int y, NonNullList<ItemStack> itemStacks) {
        this.w = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack.func_190926_b()) continue;
            this.renderItemIntoGUI(itemStack, x + this.w, y - 4);
            this.drawNumberForItem(fontRenderer, itemStack, x + this.w, y - 4);
            this.w += 18;
        }
    }

    private void renderItemIntoGUI(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemModelMesher itemModelMesher = mc.func_175599_af().func_175037_a();
        GuiRenderItem guiRenderItem = new GuiRenderItem(mc.func_110434_K(), itemModelMesher, new ItemColors());
        guiRenderItem.renderItemAndEffectIntoGUI(stack, x, y);
    }

    public void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }
}

