/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui.elements;

import com.kamildanak.minecraft.foamflower.gui.elements.GuiElement;
import com.kamildanak.minecraft.foamflower.gui.elements.TexturedBox;
import com.kamildanak.minecraft.foamflower.gui.input.InputMouseEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public class GuiExButton
extends GuiElement {
    public boolean disabled;
    public TexturedBox boxDisabled;
    public TexturedBox boxNormal;
    public TexturedBox boxOver;
    int u;
    int v;
    int texw;
    int texh;
    int borderTop;
    int borderRight;
    int borderBottom;
    int borderLeft;
    boolean over;
    private String caption;

    public GuiExButton(int x, int y, int w, int h, String caption) {
        this(x, y, w, h, caption, "textures/gui/widgets.png");
    }

    public GuiExButton(int x, int y, int w, int h, String caption, String texture) {
        super(x, y, w, h);
        this.caption = I18n.func_135052_a((String)caption, (Object[])new Object[0]).trim();
        this.disabled = false;
        this.u = 0;
        this.v = 46;
        this.texw = 200;
        this.texh = 20;
        this.borderTop = 2;
        this.borderRight = 2;
        this.borderBottom = 3;
        this.borderLeft = 2;
        this.boxDisabled = new TexturedBox(texture, 0, 46, 200, 20, 2, 2, 3, 2);
        this.boxNormal = new TexturedBox(texture, 0, 66, 200, 20, 2, 2, 3, 2);
        this.boxOver = new TexturedBox(texture, 0, 86, 200, 20, 2, 2, 3, 2);
    }

    public void setCaption(String caption) {
        this.caption = I18n.func_135052_a((String)caption, (Object[])new Object[0]).trim();
    }

    public void onClick() {
    }

    @Override
    public void render() {
        int color = -2039584;
        TexturedBox box = this.boxDisabled;
        if (!this.disabled && !this.over) {
            box = this.boxNormal;
            color = -1;
        } else if (!this.disabled) {
            box = this.boxOver;
            color = -144;
        }
        box.render(this.gui, this.x, this.y, this.w, this.h);
        this.gui.drawCenteredString(this.caption, this.x + this.w / 2, this.y + this.h / 4 + 5, color);
    }

    @Override
    public void mouseMove(InputMouseEvent ev) {
        this.over = this.isMouseOver(ev);
    }

    @Override
    public void mouseDown(InputMouseEvent ev) {
        if (!this.isMouseOver(ev)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        SoundHandler soundHandler = new SoundHandler(mc.func_110442_L(), mc.field_71474_y);
        soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        this.onClick();
    }

    @Override
    public int getHeight() {
        if (this.hidden) {
            return 0;
        }
        return this.h;
    }

    @Override
    public int getWidth() {
        if (this.hidden) {
            return 0;
        }
        return this.w;
    }
}

