/*
 * Decompiled with CFR 0.152.
 */
package com.kamildanak.minecraft.foamflower.gui;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public abstract class GuiHandler
implements Comparable<GuiHandler> {
    static ArrayList<GuiHandler> guiHandlers = new ArrayList();
    int index;
    Object mod;
    String name;

    public GuiHandler(String name) {
        guiHandlers.add(this);
        this.name = name;
    }

    public static void register(Object mod) {
        Collections.sort(guiHandlers);
        int index = 0;
        for (GuiHandler guiHandler : guiHandlers) {
            guiHandler.mod = mod;
            guiHandler.index = index++;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler(mod, new IGuiHandler(){

            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                if (ID < 0 || ID >= guiHandlers.size()) {
                    return null;
                }
                return guiHandlers.get(ID).getServerGuiElement(ID, player, world, x, y, z);
            }

            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                if (ID < 0 || ID >= guiHandlers.size()) {
                    return null;
                }
                return guiHandlers.get(ID).getClientGuiElement(ID, player, world, x, y, z);
            }
        });
    }

    public void open(EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        entityPlayer.openGui(this.mod, this.index, world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    @Override
    public int compareTo(@Nonnull GuiHandler guiHandler) {
        return this.name.compareTo(guiHandler.name);
    }

    public abstract Object getServerGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6);

    public abstract Object getClientGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6);
}

